(function() {
  //    FILE:EventModel
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['Backbone', 'moment', 'models/request/RequestModel'], function(Backbone, Moment, RequestModel) {
    var EventModel;
    return EventModel = class EventModel extends Backbone.Model {
      initialize() {
        //console.log "Model EventModel initialized"
        return this.reqMdl = new RequestModel();
      }

      get_year(day) {
        var date;
        if (day) {
          date = Moment(day, 'YYYY-MM-DD');
        } else {
          if (this.get('day').length > 1) {
            date = Moment(this.get('day'), 'YYYY-MM-DD');
          } else {
            date = Moment(this.get('Booking').day, 'YYYY-MM-DD');
          }
        }
        return date.year();
      }

      get_full_date(day) {
        var date;
        if (day) {
          date = Moment(day, 'YYYY-MM-DD');
        } else {
          date = Moment(this.get('day'), 'YYYY-MM-DD');
        }
        return date.format('LL');
      }

      get_human_date(date) {
        var now;
        //str = @.get('day')+' '+@.get('timeInAsString')
        //date = Moment(str,'YYYY-MM-DD hh:mm')
        now = Moment();
        //          if date > now then now.from(date)
        //          else
        return date.from(now);
      }

      get_details_event(sessionID, type, dayToShow) {
        var day, jsonReq, objId, response, that, xmlReq;
        jsonReq = this.reqMdl.get('JGetBooking');
        if (this.get('bookingLineID')) {
          this.reqMdl.__setNodeValue(jsonReq, 'bookingLineID', this.get('bookingLineID'));
        }
        if (this.get('bookingID')) {
          objId = this.get('bookingID');
        } else if (this.get('eventID')) {
          objId = this.get('eventID');
        }
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'bookingID', objId);
        if (dayToShow) {
          if (dayToShow === 'NOTIFICATIONDAY') {
            day = "";
          } else {
            day = dayToShow.format('YYYY-MM-DD');
          }
        } else {
          day = this.get('day');
        }
        this.reqMdl.__setNodeValue(jsonReq, 'day', day);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        that = this;
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.set(jsonObj.Result);
            // for some reason this is needed otherwise the isReadOnly property is not set
            that.set("isReadonly", jsonObj.Result.Booking.isReadonly);
            if (type === 'projectEvent' || type === 'dayplan') {
              return that.trigger('eventFilled');
            }
          }
        });
        return this;
      }

      /* REQUESTS */
      save_request(requestObject) {
        var jsonReq, parent, response, that, xmlReq;
        that = this;
        parent = 'Booking';
        jsonReq = this.reqMdl.get('JCommitBooking');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', requestObject.sessionID);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'bookingID', requestObject.bookingID);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'parentType', requestObject.parentType);
        if (requestObject.personnelTypeNumber) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'personnelTypeNumber', requestObject.personnelTypeNumber);
        }
        if (requestObject.bookingLineID) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'bookingLineID', requestObject.bookingLineID);
        }
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'name', requestObject.name);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'note', window.html_entities(requestObject.note));
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'day', requestObject.day);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'occursOnDay', requestObject.occursOnDay);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'timeIn', requestObject.timeIn);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'timeOut', requestObject.timeOut);
        if (requestObject.allDay) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'allDay', requestObject.allDay);
        }
        if (requestObject.requestUsers) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'requestUser', requestObject.requestUsers);
        }
        if (requestObject.requestGroups) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'requestGroup', requestObject.requestGroups);
        }
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'maxApprovalTime', requestObject.maxApprovalTime);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'requestStatus', requestObject.requestStatus);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        //          #console.log xmlReq
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.set(jsonObj.Result);
          }
          if (jsonObj.Result.isError === 1) {
            return that.set(jsonObj.Result);
          }
        });
        return this;
      }

      //# TASKS ###
      save_task(taskObject) {
        var jsonReq, parent, response, that, xmlReq;
        that = this;
        parent = 'Booking';
        jsonReq = this.reqMdl.get('JCommitBooking');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', taskObject.sessionID);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'bookingID', taskObject.bookingID);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'parentType', taskObject.parentType);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'name', window.html_entities(taskObject.name));
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'nameID', taskObject.name);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'status', taskObject.status);
        if (taskObject.note) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'note', window.html_entities(taskObject.note));
        }
        if (taskObject.stageName) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'stageName', taskObject.stageName);
        }
        if (taskObject.stageValue) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'stageValue', taskObject.stageValue);
        }
        if (taskObject.createdByID) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'createdByID', taskObject.createdByID);
        }
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'day', taskObject.day);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'occursOnDay', taskObject.occursOnDay);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'timeIn', taskObject.timeIn);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'timeOut', taskObject.timeOut);
        if (taskObject.Involved) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'Involved', taskObject.Involved);
        }
        if (taskObject.CustomField) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'CustomField', taskObject.CustomField);
        }
        xmlReq = this.reqMdl.__getXML(jsonReq);
        //          #console.log xmlReq
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            return that.set(jsonObj.Result);
          }
        });
        return this;
      }

      //# BOOKINGS ###
      save_booking(taskObject) {
        var jsonReq, parent, response, that, xmlReq;
        that = this;
        parent = 'Booking';
        jsonReq = this.reqMdl.get('JCommitBooking');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', taskObject.sessionID);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'bookingID', taskObject.bookingID);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'parentType', taskObject.parentType);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'parentID', taskObject.parentID);
        if (taskObject.projectBinderID) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'projectBinderID', taskObject.projectBinderID);
        }
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'name', window.html_entities(taskObject.name));
        if (taskObject.nameID) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'nameID', taskObject.nameID);
        }
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'status', taskObject.status);
        if (taskObject.note) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'note', window.html_entities(taskObject.note));
        }
        if (taskObject.stageName) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'stageName', taskObject.stageName);
        }
        if (taskObject.stageValue) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'stageValue', taskObject.stageValue);
        }
        if (taskObject.createdByID) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'createdByID', taskObject.createdByID);
        }
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'day', taskObject.day);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'occursOnDay', taskObject.occursOnDay);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'timeIn', taskObject.timeIn);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'timeOut', taskObject.timeOut);
        if (taskObject.Involved) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'Involved', taskObject.Involved);
        }
        if (taskObject.CustomField) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'CustomField', taskObject.CustomField);
        }
        xmlReq = this.reqMdl.__getXML(jsonReq);
        //          #console.log xmlReq
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.set(jsonObj.Result);
          }
          if (jsonObj.Result.isError === 1 && jsonObj.Result.EventCommitConflicts) {
            return that.set(jsonObj.Result);
          }
        });
        return this;
      }

      set_booking_accept_status(requestObject) {
        var jsonReq, xmlReq;
        jsonReq = this.reqMdl.get('JSetBookingAcceptStatus');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', requestObject.sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'eventID', requestObject.eventID);
        this.reqMdl.__setNodeValue(jsonReq, 'bookingLineID', requestObject.bookingLineID);
        this.reqMdl.__setNodeValue(jsonReq, 'acceptStatus', requestObject.acceptStatus);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        return this.reqMdl.__send_server_xmlrequest(xmlReq);
      }

      set_decline_note(requestObject) {
        var jsonReq, xmlReq;
        jsonReq = this.reqMdl.get('JSetDeclinedNote');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', requestObject.sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'eventID', requestObject.eventID);
        this.reqMdl.__setNodeValue(jsonReq, 'bookingLineID', requestObject.bookingLineID);
        this.reqMdl.__setNodeValue(jsonReq, 'declinedNote', requestObject.declinedNote);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        return this.reqMdl.__send_server_xmlrequest(xmlReq);
      }

      set_booking_note(requestObject) {
        var jsonReq, xmlReq;
        jsonReq = this.reqMdl.get('JSetBookingNote');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', requestObject.sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'bookingID', requestObject.bookingID);
        this.reqMdl.__setNodeValue(jsonReq, 'note', requestObject.note);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        return this.reqMdl.__send_server_xmlrequest(xmlReq); //#
      }

      /* EVENTS */
      delete_event(requestObject) {
        var jsonReq, response, that, xmlReq;
        that = this;
        jsonReq = this.reqMdl.get('JDeleteBooking');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', requestObject.sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'bookingID', requestObject.bookingID);
        this.reqMdl.__setNodeValue(jsonReq, 'bookingLineID', requestObject.bookingLineID);
        this.reqMdl.__setNodeValue(jsonReq, 'day', requestObject.day);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        //          #console.log xmlReq
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.set(jsonObj.Result);
            that.trigger('delete');
          }
          if (jsonObj.Result.isError === 1) {
            return that.set(jsonObj.Result);
          }
        });
        return this;
      }

      __is_all_day() {
        var ref, ref1;
        if (this.get('isAlldayEvent') === 1) {
          return true;
        } else if (((ref = this.get('Booking')) != null ? ref.timeIn : void 0) === 0 && ((ref1 = this.get('Booking')) != null ? ref1.timeOut : void 0) === 24) {
          return true;
        } else {
          return false;
        }
      }

      //HELPER SET EVENT DATES
      __get_first_and_last_day(day) {
        var ref;
        if (_.isArray((ref = this.get('Booking')) != null ? ref.occursOnDay : void 0)) {
          return {
            dayIn: Moment(this.get('Booking').occursOnDay[0], 'YYYY-MM-DD').format('DD-MM-YYYY'),
            dayOut: Moment(this.get('Booking').occursOnDay[this.get('Booking').occursOnDay.length - 1], 'YYYY-MM-DD').format('DD-MM-YYYY')
          };
        } else {
          return {
            dayIn: day.format('DD-MM-YYYY'),
            dayOut: day.format('DD-MM-YYYY')
          };
        }
      }

      __has_consecutive_days() {
        var dayIn, dayOut, ref;
        if (_.isArray((ref = this.get('Booking')) != null ? ref.occursOnDay : void 0)) {
          dayIn = Moment(this.get('Booking').occursOnDay[0], 'YYYY-MM-DD');
          dayOut = Moment(this.get('Booking').occursOnDay[this.get('Booking').occursOnDay.length - 1], 'YYYY-MM-DD');
          if ((dayOut.diff(dayIn, 'days') + 1) === this.get('Booking').occursOnDay.length) {
            return true;
          } else {
            return false;
          }
        } else {
          return true;
        }
      }

      __user_can_edit_event(user) {
        if (this.get('isReadonly') === 0) {
          return true;
        }
        if (this.get('type') === 'request' && this.get('requestStatus') === 'accepted' && user.__can_modify_approved_requests()) {
          return true;
        } else {
          return false;
        }
      }

    };
  });

}).call(this);
